local t = Def.ActorFrame {};
-- A very useful table...
local eval_lines = {
	"W1",
	"W2",
	"W3",
	"W4",
	"W5",
	"Miss",
	"Held",
	"MaxCombo"
}

-- And a function to make even better use out of the table.
local function GetJLineValue(line, pl)
	if line == "Held" then
		return STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(pl):GetHoldNoteScores("HoldNoteScore_Held")
	elseif line == "MaxCombo" then
		return STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(pl):MaxCombo()
	else
		return STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(pl):GetTapNoteScores("TapNoteScore_" .. line)
	end
	return "???"
end

-- #################################################
-- That's enough functions; let's get this done.


t[#t+1] = mid_pane

-- #################################################
-- Player stats and labels 
if GAMESTATE:IsHumanPlayer(PLAYER_1) then 
	local p1evalx = SCREEN_CENTER_X-420
	local p1evaly = SCREEN_TOP+150
	local eval_offset = 44
	local p_grade = STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(PLAYER_1):GetGrade()

	--Grade pane P1
	t[#t+1] = Def.ActorFrame {
		OnCommand=function(self) self:diffusealpha(0):addx(-20):sleep(0.02):linear(0.1):diffusealpha(1):addx(20) end;
		OffCommand=function(self) self:decelerate(0.3):diffusealpha(0):addx(-20) end;
		LoadActor(THEME:GetPathG("GradeDisplay", "Grade " .. p_grade)) .. {
			InitCommand=function(self) self:zoom(0.75):horizalign(center):xy(p1evalx+100,p1evaly) end;
			OnCommand=function(self) self:zoom(0.75):diffusealpha(0):sleep(0.8):smooth(0.3):zoom(1.25):diffusealpha(1) end;
		},
	};
	
	-- Row loop
	for i, v in ipairs(eval_lines) do
	local spacing = 23*i
	local cur_line = "JudgmentLine_" .. v
	
	
	t[#t+1] = Def.ActorFrame {
		OnCommand=function(self) self:diffusealpha(0):addx(-20):sleep(0.05*i):linear(0.1):diffusealpha(1):addx(20) end;
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			InitCommand=cmd(horizalign,left;x,p1evalx;y,p1evaly+eval_offset+spacing;);
		};
		LoadFont("_coaster") .. {
			InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,JudgmentLineToColor(cur_line);x,p1evalx+8;y,p1evaly+eval_offset+spacing;settext,string.upper(JudgmentLineToLocalizedString(cur_line)););
		};
		LoadFont("_coaster") .. {
			InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,ColorLightTone(JudgmentLineToColor(cur_line));x,p1evalx+190;y,p1evaly+eval_offset+spacing);
			OnCommand=function(self)
				self:settext(GetJLineValue(v, PLAYER_1))
			end,
		};
	};
	end;

		-- Score P1
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p1evalx+100;y,p1evaly+eval_offset+23*9;horizalign,right;visible,not PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			};
			LoadFont("Common Normal") .. {
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"SCORE";addx,-91);
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addx,90);
				OnCommand=function(self)
					self:settext(STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(PLAYER_1):GetScore())
				end;
			};
		};
		-- Percent
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p1evalx+100;y,p1evaly+eval_offset+23*9;horizalign,right;visible,PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,-20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,-20;);
		LoadActor(THEME:GetPathG("_eval", "line p1")) .. {
			};
			LoadFont("Common Normal") .. {
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#BFD5F7");strokecolor,color("#326CB4");settext,"SCORE";addx,-91);
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#BFD5F7");addx,90);
				OnCommand=function(self)
					local p1percent = STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(PLAYER_1):GetPercentDancePoints()
					self:settext(FormatPercentScore(p1percent))
				end;
			};
		};
end;

if GAMESTATE:IsHumanPlayer(PLAYER_2) then 
	local p2evalx = SCREEN_CENTER_X+170+81-31
	local p2evaly = SCREEN_TOP+150
	local eval_offset = 44
	local p_grade = STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(PLAYER_2):GetGrade()

		
	-- Grade pane P2
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.02;linear,0.2;diffusealpha,1;addx,-20;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
		--LoadActor(THEME:GetPathG("_summary", "pane p2")) .. {
		--	InitCommand=cmd(horizalign,left;x,p2evalx;y,p2evaly);
		--};
		LoadActor(THEME:GetPathG("GradeDisplay", "Grade " .. p_grade)) .. {
			InitCommand=cmd(zoom,0.75;horizalign,center;x,p2evalx+100;y,p2evaly);
			OnCommand=cmd(zoom,0.75;diffusealpha,0;sleep,0.8;smooth,0.3;zoom,1.25;diffusealpha,1);
		},
	};
	
	--Row loop
	for i, v in ipairs(eval_lines) do
	local spacing = 23*i
	local cur_line = "JudgmentLine_" .. v
	
	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*i;linear,0.1;diffusealpha,1;addx,-20;);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			InitCommand=cmd(horizalign,left;x,p2evalx;y,p2evaly+eval_offset+spacing;);
		};
		LoadFont("_coaster") .. {
			InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,JudgmentLineToColor(cur_line);diffusebottomedge,color("#BFD5F7");x,p2evalx+8;y,p2evaly+eval_offset+spacing;settext,string.upper(JudgmentLineToLocalizedString(cur_line)););
		};
		LoadFont("_coaster") .. {
			InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,ColorLightTone(JudgmentLineToColor(cur_line));x,p2evalx+190;y,p2evaly+eval_offset+spacing);
			OnCommand=function(self)
				self:settext(GetJLineValue(v, PLAYER_2))
			end,
		};
	};
	end;
	
		-- Score P2
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*9;horizalign,right;visible,not PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,-20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);	
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			};
			LoadFont("Common Normal") .. {
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"SCORE";addx,-91);
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addy,-1;addx,90);
				OnCommand=function(self)
					self:settext(STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(PLAYER_2):GetScore())
				end;
			};
		};
		-- Percent
		t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,p2evalx+100;y,p2evaly+eval_offset+23*9;horizalign,right;visible,PREFSMAN:GetPreference("PercentageScoring"));
		OnCommand=cmd(diffusealpha,0;addx,20;sleep,0.05*9;linear,0.1;diffusealpha,1;addx,-20);
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,20;);		
		LoadActor(THEME:GetPathG("_eval", "line p2")) .. {
			};
			LoadFont("Common Normal") .. {
				InitCommand=cmd(horizalign,left;zoom,0.75;diffuse,color("#FBFBAA");strokecolor,color("#BFA558");settext,"SCORE";addx,-91);
			};
			LoadFont("_coaster") .. {
				InitCommand=cmd(horizalign,right;zoom,0.75;diffuse,color("#FBFBAA");addx,90);
				OnCommand=function(self)
					local p2percent = STATSMAN:GetAccumPlayedStageStats():GetPlayerStageStats(PLAYER_2):GetPercentDancePoints()
					self:settext(FormatPercentScore(p2percent))
				end;
			};
		};
		
end;

return t;